/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.step.core.attachments;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWParameter;
import filenet.vw.api.VWStepElement;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.step.core.VWStepBaseListPanel;
import filenet.vw.toolkit.runtime.step.core.attachments.VWAttachmentHelper;
import filenet.vw.toolkit.runtime.step.core.attachments.VWAttachmentTableModel;
import filenet.vw.toolkit.runtime.step.core.attachments.VWAttachmentToolBar;
import filenet.vw.toolkit.runtime.step.core.attachments.VWIDMItem;
import filenet.vw.toolkit.runtime.step.core.attachments.VWIDMItemRenderer;
import filenet.vw.toolkit.runtime.step.resources.VWResource;
import filenet.vw.toolkit.utils.IVWMouseActionListener;
import filenet.vw.toolkit.utils.VWAttachmentSelectionHelper;
import filenet.vw.toolkit.utils.VWMouseAdapter;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.table.VWExpandButtonEditor;
import filenet.vw.toolkit.utils.table.VWExpandButtonRenderer;
import filenet.vw.toolkit.utils.table.VWParameterRenderer;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class VWAttachmentListPanel
extends VWStepBaseListPanel
implements IVWMouseActionListener {
    private VWAttachmentTableModel m_vwAttachmentTableModel = null;
    private VWAttachmentToolBar m_attachmentToolBar = null;
    private Frame m_parentFrame = null;
    private VWSessionInfo m_sessionInfo = null;

    public VWAttachmentListPanel() {
        try {
            this.m_sessionInfo = new VWSessionInfo(null, null);
            this.m_table.setDefaultRenderer(Boolean.class, new VWExpandButtonRenderer());
            this.m_table.setDefaultEditor(Boolean.class, new VWExpandButtonEditor(new JButton()));
            this.m_table.setDefaultRenderer(VWParameter.class, new VWParameterRenderer());
            this.m_table.setDefaultRenderer(VWIDMItem.class, new VWIDMItemRenderer());
            this.m_table.addMouseListener(new VWMouseAdapter(this));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void init(VWStepElement stepElement) {
        super.init(stepElement);
        this.m_vwAttachmentTableModel = new VWAttachmentTableModel(stepElement, this.m_sessionInfo);
        this.m_table.setModel(this.m_vwAttachmentTableModel);
        TableColumnModel columnModel = this.m_table.getColumnModel();
        TableColumn columnExpand = columnModel.getColumn(0);
        columnExpand.setMinWidth(15);
        columnExpand.setMaxWidth(15);
    }

    public void setParentFrame(Frame parentFrame) {
        this.m_parentFrame = parentFrame;
    }

    public void doubleClickedItem(MouseEvent event) {
        try {
            if (this.m_table == null) {
                return;
            }
            Point pt = event.getPoint();
            int nRowIndex = this.m_table.rowAtPoint(pt);
            int nColumnIndex = this.m_table.columnAtPoint(pt);
            if (nRowIndex == -1 || nColumnIndex == -1) {
                return;
            }
            if (this.m_vwAttachmentTableModel != null) {
                this.m_vwAttachmentTableModel.openItem(nRowIndex);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void createPopup(MouseEvent event) {
        try {
            int nContextMenuRow = this.m_table.rowAtPoint(new Point(event.getX(), event.getY()));
            if (nContextMenuRow != -1) {
                this.m_table.setRowSelectionInterval(nContextMenuRow, nContextMenuRow);
                JPopupMenu popupMenu = this.m_attachmentToolBar.getContextMenu();
                if (popupMenu != null) {
                    popupMenu.show(event.getComponent(), event.getX(), event.getY());
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void setToolBar(VWAttachmentToolBar toolBar) {
        this.m_attachmentToolBar = toolBar;
    }

    protected void addAttachment(VWIDMItem idmItem) {
        try {
            if (idmItem == null || this.m_table == null) {
                return;
            }
            int nSelectedRow = this.m_table.getSelectedRow();
            if (nSelectedRow == -1) {
                return;
            }
            if (!idmItem.isArray()) {
                return;
            }
            VWAttachment newAttachment = VWAttachmentSelectionHelper.browseForAttachment(null, VWResource.s_addAttachmentToArray, this.m_parentFrame);
            if (newAttachment != null) {
                String attachmentName = null;
                attachmentName = newAttachment.getType() == 5 ? newAttachment.getId() : newAttachment.getAttachmentName();
                if (attachmentName != null && attachmentName.length() > 0) {
                    this.m_vwAttachmentTableModel.addAttachment(nSelectedRow, newAttachment);
                    this.m_table.setRowSelectionInterval(nSelectedRow, nSelectedRow);
                } else {
                    JOptionPane.showMessageDialog(null, VWResource.s_emptyAttachmentName, VWResource.s_unableToAddAttachment, 0);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void deleteItem(VWIDMItem idmItem) {
        try {
            if (idmItem == null || this.m_table == null) {
                return;
            }
            int nSelectedRow = this.m_table.getSelectedRow();
            if (nSelectedRow == -1) {
                return;
            }
            if (!idmItem.isArray()) {
                return;
            }
            this.m_vwAttachmentTableModel.deleteAttachment(nSelectedRow, idmItem.getAttachment());
            if (nSelectedRow > this.m_table.getRowCount() - 1) {
                this.m_table.setRowSelectionInterval(nSelectedRow - 1, nSelectedRow - 1);
            } else {
                this.m_table.setRowSelectionInterval(nSelectedRow, nSelectedRow);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void assignDocument(VWIDMItem idmItem) {
        try {
            if (idmItem == null || this.m_table == null) {
                return;
            }
            int nSelectedRow = this.m_table.getSelectedRow();
            if (nSelectedRow == -1) {
                return;
            }
            VWAttachment newAttachment = VWAttachmentSelectionHelper.browseForAttachment(null, VWResource.s_browse, this.m_parentFrame);
            if (newAttachment != null) {
                VWAttachment oldAttachment = idmItem.getAttachment();
                if (oldAttachment != null) {
                    newAttachment.setAttachmentDescription(oldAttachment.getAttachmentDescription());
                }
                this.m_vwAttachmentTableModel.updateAttachment(nSelectedRow, newAttachment);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void unassignDocument(VWIDMItem idmItem) {
        try {
            if (idmItem == null || this.m_table == null) {
                return;
            }
            int nSelectedRow = this.m_table.getSelectedRow();
            if (nSelectedRow == -1) {
                return;
            }
            this.m_vwAttachmentTableModel.updateAttachment(nSelectedRow, new VWAttachment());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void syncItemName(VWIDMItem idmItem) {
        try {
            if (idmItem == null || this.m_table == null || this.m_vwAttachmentTableModel == null) {
                return;
            }
            int nSelectedRow = this.m_table.getSelectedRow();
            if (nSelectedRow == -1) {
                return;
            }
            VWAttachmentHelper vwAttachmentHelper = idmItem.getAttachmentHelper();
            if (vwAttachmentHelper != null && vwAttachmentHelper.hasNameChanged()) {
                this.m_vwAttachmentTableModel.updateAttachment(nSelectedRow, idmItem.getAttachment());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void refreshSelectedItemState() {
        int nSelectedRow = this.m_table.getSelectedRow();
        if (nSelectedRow == -1) {
            return;
        }
        this.m_vwAttachmentTableModel.fireTableRowsUpdated(nSelectedRow, nSelectedRow);
    }

    protected VWIDMItem getSelectedItem() {
        int nSelectedRow = this.m_table.getSelectedRow();
        if (nSelectedRow == -1) {
            return null;
        }
        if (this.m_vwAttachmentTableModel.isRowEditable(nSelectedRow)) {
            return (VWIDMItem)this.m_vwAttachmentTableModel.getValueAt(nSelectedRow, 2);
        }
        return null;
    }

    protected VWSessionInfo getSessionInfo() {
        return this.m_sessionInfo;
    }
}

